package fr.asip.cps3.exemple.modele.exceptions;


/**
 * Classe d'exception applicative intervenant au niveau des contrleurs de l'applications
 */
public class ExceptionControleur extends ExceptionProgrammeExemple {

	private static final long serialVersionUID = 5967813579001442180L;
	
	/**
	 * Code du type de controleur
	 */
	private int typeControleur = -1;
	
	/**
	 * Constructeur
	 * @param typeControleur Code du type de contrleur
	 */
	public ExceptionControleur(int typeControleur) {
		super();
		this.typeControleur = typeControleur;
	}

	/**
	 * Constructeur
	 * @param typeControleur Code du type de contrleur 
	 * @param message Intitul de l'exception
	 * @param cause Cause de l'exception
	 */
	public ExceptionControleur(int typeControleur, String message, Throwable cause) {
		super(message, cause);
		this.typeControleur = typeControleur;
	}

	/**
	 * Constructeur
	 * @param typeControleur Code du type de contrleur 
	 * @param message Intitul de l'exception
	 */
	public ExceptionControleur(int typeControleur, String message) {
		super(message);
		this.typeControleur = typeControleur;
	}

	/**
	 * Constructeur
	 * @param typeControleur Code du type de contrleur 
	 * @param message Intitul de l'exception
	 * @param cause Cause de l'exception
	 */
	public ExceptionControleur(int typeControleur, Throwable cause) {
		super(cause);
		this.typeControleur = typeControleur;
	}

	/**
	 * Accesseur
	 * @return le code de type de contrleur
	 */
	public int getTypeControleur() {
		return typeControleur;
	}

	/**
	 * Dtermine le type d'exception
	 * @return Le type d'exception
	 */
	public String getTypeException() {
		
		switch(typeControleur) {
		
			case ExceptionProgrammeExemple.TYPE_CONTROLEUR_APPLICATION:
				return ("Exception contrleur application");

			case ExceptionProgrammeExemple.TYPE_CONTROLEUR_ECRAN:
				return ("Exception contrleur cran");

			case ExceptionProgrammeExemple.TYPE_CONTROLEUR_MENU:
				return ("Exception contrleur menu");
				
			default:
				return "Exception contrleur";
		}
			
	}
	
}
